#ifndef _MULTISYNC_H_
#define _MULTISYNC_H_

#pragma comment(lib, "MultisyncDLL.lib")

// Core prototypes
bool           NetHost(int playerAmount);
bool           NetHost_IP(int playerAmount, char * ipAddress);
bool           NetConnect(char * ipAddress);
void           NetDisconnect();
void           NetSend(int player);
void           NetSendAll();
bool           NetGetMessage();
unsigned long  NetGetMessageSize();
unsigned long  NetGetMessageRemainder();
int            NetMessageFrom();
int            NetPlayerJoined();
int            NetPlayerLeft();
int            NetGetPlayerAmount();
bool           NetPlayerConnected(int player);
void           NetKick(int player);
bool           NetConnected();
void           NetGetError(char * outBuffer, unsigned long outBufferSize);
void           NetSetPort(unsigned short port);
void           NetSetOption(int option, int value);
int            NetGetOption(int option);
void           NetGetPlayerIP(int player, char * outBuffer, unsigned long outBufferSize);
unsigned short NetGetPlayerPort(int player);
bool           NetFirewallEnabled();
bool           NetFirewallApplicationEnabled(char * appPath);
bool           NetFirewallEnableApplication(char * appPath, char * appName);

// Message prototypes
void           NetPutByte(unsigned char data);
void           NetPutWord(unsigned short data);
void           NetPutLong(unsigned long data);
void           NetPutInt(int data);
void           NetPutFloat(float data);
void           NetPutString(char * stringData);
void           NetPutData(const char * buffer, int sizeInBytes);
unsigned char  NetGetByte();
unsigned short NetGetWord();
unsigned long  NetGetLong();
int            NetGetInt();
float          NetGetFloat();
void           NetGetString(char * outBuffer, unsigned long outBufferSize);
void           NetGetData(char * buffer, int sizeInBytes);

#endif _MULTISYNC_H_